#include <stdio.h>

void print_bin(void *ad, int no_bytes)
     /***********************************************************/
     /* Prints out the contents of a number of bytes of memory  */
     /* in binary.                                              */
     /* INPUTS:                                                 */
     /*        void *ad:     The starting address of the memory */
     /*                      to be printed out                  */
     /*        int no_bytes: The number of bytes to print out   */
     /*                                                         */
     /* NOTE:                                                   */
     /*      The LINUX machines are an example of a "Little     */
     /*      Endian" machine meaning that the most signficant   */
     /*      byte of a variable is stored at the largest address*/
     /*      of the block of memory allocated to it  - so this  */
     /*      subroutine prints from the most significant byte   */
     /*      to the least significant byte                      */
     /***********************************************************/
{
  char *byte_add;
  int bit_no;
 for (byte_add = (char *)ad + (no_bytes - 1);byte_add>=ad;byte_add--) {
   for (bit_no = 7;bit_no>=0;bit_no--){
     if (((char)*byte_add>>bit_no)&1)
       printf("1");
     else
       printf("0");
   }
   printf(" ");
 }
 printf("\n");
}
