/*
* ========== Copyright Header Begin ==========================================
*
* Hypervisor Software File: prom_cpuctl.c
* 
* Copyright (c) 2006 Sun Microsystems, Inc. All Rights Reserved.
* 
*  - Do no alter or remove copyright notices
* 
*  - Redistribution and use of this software in source and binary forms, with 
*    or without modification, are permitted provided that the following 
*    conditions are met: 
* 
*  - Redistribution of source code must retain the above copyright notice, 
*    this list of conditions and the following disclaimer.
* 
*  - Redistribution in binary form must reproduce the above copyright notice,
*    this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution. 
* 
*    Neither the name of Sun Microsystems, Inc. or the names of contributors 
* may be used to endorse or promote products derived from this software 
* without specific prior written permission. 
* 
*     This software is provided "AS IS," without a warranty of any kind. 
* ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND WARRANTIES, 
* INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, FITNESS FOR A 
* PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY EXCLUDED. SUN 
* MICROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL NOT BE LIABLE FOR 
* ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR 
* DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES. IN NO EVENT WILL SUN 
* OR ITS LICENSORS BE LIABLE FOR ANY LOST REVENUE, PROFIT OR DATA, OR 
* FOR DIRECT, INDIRECT, SPECIAL, CONSEQUENTIAL, INCIDENTAL OR PUNITIVE 
* DAMAGES, HOWEVER CAUSED AND REGARDLESS OF THE THEORY OF LIABILITY, 
* ARISING OUT OF THE USE OF OR INABILITY TO USE THIS SOFTWARE, EVEN IF 
* SUN HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.
* 
* You acknowledge that this software is not designed, licensed or
* intended for use in the design, construction, operation or maintenance of
* any nuclear facility. 
* 
* ========== Copyright Header End ============================================
*/
/*
 * Copyright (c) 2000-2003 Sun Microsystems, Inc.
 * All rights reserved.
 * Use is subject to license terms.
 */

#pragma ident	"@(#)prom_cpuctl.c	1.1	00/07/22 SMI"

#include <sys/promif.h>
#include <sys/promimpl.h>

int
prom_idle_self(void)
{
	cell_t ci[3];

	ci[0] = p1275_ptr2cell("SUNW,idle-self");	/* Service name */
	ci[1] = (cell_t)0;			/* #argument cells */
	ci[2] = (cell_t)0;			/* #result cells */
	(void) p1275_cif_handler(&ci);
	return (0);
}

int
prom_resumecpu(dnode_t node)
{
	cell_t ci[4];

	ci[0] = p1275_ptr2cell("SUNW,resume-cpu");	/* Service name */
	ci[1] = (cell_t)1;			/* #argument cells */
	ci[2] = (cell_t)0;			/* #result cells */
	ci[3] = p1275_dnode2cell(node);		/* Arg1: nodeid to start */

	(void) p1275_cif_handler(&ci);

	return (0);
}

int
prom_stop_self(void)
{
	cell_t ci[3];

	ci[0] = p1275_ptr2cell("SUNW,stop-self");	/* Service name */
	ci[1] = (cell_t)0;			/* #argument cells */
	ci[2] = (cell_t)0;			/* #result cells */
	(void) p1275_cif_handler(&ci);
	return (0);
}

int
prom_startcpu(dnode_t node, caddr_t pc, int32_t arg)
{
	cell_t ci[6];

	ci[0] = p1275_ptr2cell("SUNW,start-cpu");	/* Service name */
	ci[1] = (cell_t)3;			/* #argument cells */
	ci[2] = (cell_t)0;			/* #result cells */
	ci[3] = p1275_dnode2cell(node);		/* Arg1: nodeid to start */
	ci[4] = p1275_ptr2cell(pc);		/* Arg2: pc */
	ci[5] = p1275_int2cell(arg);		/* Arg3: cpuid */

	(void) p1275_cif_handler(&ci);

	return (0);
}
