/*
 * libhfs - library for reading and writing Macintosh HFS volumes
 * Copyright (C) 1996, 1997 Robert Leslie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: record.h,v 1.4 1997/08/25 23:02:06 rob Exp $
 */

void r_packcatkey(const CatKeyRec *, unsigned char *, int *);
void r_unpackcatkey(const unsigned char *, CatKeyRec *);

void r_packextkey(const ExtKeyRec *, unsigned char *, int *);
void r_unpackextkey(const unsigned char *, ExtKeyRec *);

int r_comparecatkeys(const unsigned char *, const unsigned char *);
int r_compareextkeys(const unsigned char *, const unsigned char *);

void r_packcatdata(const CatDataRec *, unsigned char *, int *);
void r_unpackcatdata(const unsigned char *, CatDataRec *);

void r_packextdata(const ExtDataRec *, unsigned char *, int *);
void r_unpackextdata(const unsigned char *, ExtDataRec *);

void r_makecatkey(CatKeyRec *, long, const char *);
void r_makeextkey(ExtKeyRec *, int, long, unsigned int);

void r_packdirent(CatDataRec *, const hfsdirent *);
void r_unpackdirent(long, const char *, const CatDataRec *, hfsdirent *);
