/*
 * hfsutils - tools for reading and writing Macintosh HFS volumes
 * Copyright (C) 1996, 1997 Robert Leslie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: ck_btree.c,v 1.2 1997/08/01 15:57:55 rob Exp $
 */

# include <stdio.h>

# include "hfsck.h"
# include "util.h"

# include "ck_btree.h"

/*
 * NAME:	getnode()
 * DESCRIPTION:	retrieve a numbered node from a B*-tree file without checks
 */
static
int getnode(node *np)
{
  btree *bt = np->bt;
  block *bp = &np->data;
  unsigned char *ptr;
  int i;
}

/*
 * NAME:	ck->btree()
 * DESCRIPTION:	verify/repair a b*-tree
 */
int ck_btree(btree *bt)
{
  printf("*** Checking %s B*-tree\n", bt->f.name);

  

  return 0;
}
