# include <stdio.h>
# include <string.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "humount.h"

#ifdef __BEOS__

int external_func(int argc, char *argv[])
{
  return humount_main(argc, argv);
}

#endif // __BEOS__

/*
 * NAME:	humount->main()
 * DESCRIPTION:	implement humount command
 */
int humount_main(int argc, char *argv[])
{
  int vnum;
  mountent *ent;

  if (argc > 2)
    {
      fprintf(stderr, "Usage: %s [volume-name-or-path]\n", argv[0]);
      return 1;
    }

  if (argc == 1)
    {
      if (hcwd_umounted(-1) < 0)
	{
	  if (hcwd_getvol(-1) == 0)
	    {
	      fprintf(stderr, "%s: No volume is current\n", argv[0]);
	      return 1;
	    }
	}

      return 0;
    }

  for (ent = hcwd_getvol(vnum = 0); ent; ent = hcwd_getvol(++vnum))
    {
      if (strcmp(argv[1], ent->path) == 0 ||
	  strcasecmp(argv[1], ent->vname) == 0)
	{
	  hcwd_umounted(vnum);
	  return 0;
	}
    }

  fprintf(stderr, "%s: Unknown volume \"%s\"\n", argv[0], argv[1]);

  return 1;
}
