# include <stdio.h>
# include <stdlib.h>
# include <fcntl.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "hmount.h"

#ifdef __BEOS__

int external_func(int argc, char *argv[])
{
  return hmount_main(argc, argv);
}

#endif // __BEOS__

/*
 * NAME:	hmount->main()
 * DESCRIPTION:	implement hmount command
 */
int hmount_main(int argc, char *argv[])
{
  char *path;
  hfsvol *vol;
  hfsvolent ent;
  int partno, result = 0;

  if (argc < 2 || argc > 3)
    {
      fprintf(stderr, "Usage: %s source-path [partition-no]\n", argv[0]);
      return 1;
    }

  path   = argv[1];
  partno = (argc == 3) ? atoi(argv[2]) : 1;

  vol = hfs_mount(path, partno, O_RDWR);
  if (vol == 0)
    {
      hfs_perror(path);
      return 1;
    }

  hfs_vstat(vol, &ent);
  hfs_pinfo(&ent);

  if (hcwd_mounted(ent.name, ent.crdate, path, partno) < 0)
    {
      perror("Failed to record mount");
      result = 1;
    }

  if (hfs_umount(vol) < 0 && result == 0)
    {
      hfs_perror("Error closing HFS volume");
      result = 1;
    }

  return result;
}
