/*
 * hfsutils - tools for reading and writing Macintosh HFS volumes
 * Copyright (C) 1996, 1997 Robert Leslie
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

# include <unistd.h>

# include "suid.h"

static uid_t euid;
static gid_t egid;

/*
 * NAME:	suid->init()
 * DESCRIPTION:	initialize application which may be running setuid/setgid
 */
void suid_init(int enable)
{
  euid = geteuid();
  egid = getegid();

  if (! enable)
    suid_disable();
}

/*
 * NAME:	suid->enable()
 * DESCRIPTION:	engage any setuid privileges
 */
void suid_enable(void)
{
  seteuid(euid);
  setegid(egid);
}

/*
 * NAME:	suid->disable()
 * DESCRIPTION:	revoke all setuid privileges
 */
void suid_disable(void)
{
  seteuid(getuid());
  setegid(getgid());
}
