# include <stdio.h>
# include <stdlib.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "hmount.h"

int hmount_main(int argc, char *argv[])
{
  char *path;
  hfsvol *vol;
  int partno;

  if (argc < 2 || argc > 3)
    {
      fprintf(stderr, "Usage: %s source-path [partition-no]\n", argv[0]);
      return 1;
    }

  path   = argv[1];
  partno = (argc == 3) ? atoi(argv[2]) : 1;

  vol = hfs_mount(path, partno);
  if (vol == 0)
    {
      hfs_perror(path);
      return 1;
    }

  hfs_pinfo(vol);

  if (hcwd_mounted(hfs_vname(vol), hfs_vcrdate(vol), path, partno) < 0)
    {
      perror("Failed to record mount");
      return 1;
    }

  if (hfs_umount(vol) < 0)
    {
      hfs_perror("Error closing HFS volume");
      return 1;
    }

  return 0;
}
