# include <stdlib.h>
# include <stdio.h>
# include <tk.h>

# include "tclhfs.h"
# include "xhfs.h"

int Tcl_AppInit(Tcl_Interp *interp)
{
  if (Tcl_Init(interp) == TCL_ERROR)
    return TCL_ERROR;

  if (Tk_Init(interp) == TCL_ERROR)
    return TCL_ERROR;

  if (Hfs_Init(interp) == TCL_ERROR)
    return TCL_ERROR;

  tcl_RcFileName = "~/.hfsrc";

  if (Tcl_Eval(interp, xhfs) == TCL_ERROR)
    return TCL_ERROR;

  return TCL_OK;
}

int main(int argc, char *argv[])
{
  int nargc = argc;
  char **nargv;
  int i;

  nargc += 2;
  nargv = malloc(sizeof(*nargv) * nargc);
  if (nargv == 0)
    {
      perror(argv[0]);
      return 1;
    }

  nargv[0] = argv[0];
  nargv[1] = "/dev/null";
  nargv[2] = "--";

  for (i = 3; i < nargc; ++i)
    nargv[i] = argv[i - 2];

  Tk_Main(nargc, nargv, Tcl_AppInit);

  return 0;  /* not reached */
}
