# include <stdio.h>
# include <stdlib.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "hformat.h"

int hformat_main(int argc, char *argv[])
{
  int nargc = argc;
  char **nargv = argv;
  char *path, *vname;
  hfsvol *vol;
  int partno;

  vname = "Untitled";

  if (nargc > 2 && strcmp(nargv[1], "-l") == 0)
    {
      vname = nargv[2];
      nargv += 2, nargc -= 2;
    }

  if (nargc < 2 || nargc > 3)
    {
      fprintf(stderr, "Usage: %s [-l label] device-path [partition-no]\n",
	      argv[0]);
      return 1;
    }

  path   = nargv[1];
  partno = (nargc == 3) ? atoi(nargv[2]) : 0;

  if (hfs_format(path, partno, vname) < 0)
    {
      hfs_perror(path);
      return 1;
    }

  vol = hfs_mount(path, partno);
  if (vol == 0)
    {
      hfs_perror(path);
      return 1;
    }

  hfs_pinfo(vol);

  if (hcwd_mounted(hfs_vname(vol), hfs_vcrdate(vol), path, partno) < 0)
    {
      perror("Failed to record mount");
      return 1;
    }

  if (hfs_umount(vol) < 0)
    {
      hfs_perror("Error closing HFS volume");
      return 1;
    }

  return 0;
}
