# include <stdio.h>
# include <string.h>
# include <unistd.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "hcat.h"

int hcat_main(int argc, char *argv[])
{
  int nargc = argc;
  char **nargv = argv;
  hfsvol *vol;
  hfsfile *file;
  hfsdirent dirent;
  char buf[HFS_BLOCKSZ];
  int text, fork, bytes;

  if (nargc > 1 && strcmp(nargv[1], "-r") == 0)
    {
      fork = 1;
      ++nargv, --nargc;
    }
  else
    fork = 0;

  if (nargc != 2)
    {
      fprintf(stderr, "Usage: %s [-r] hfs-path\n", argv[0]);
      return 1;
    }

  vol = hfs_remount(argv[0], hcwd_getvol(-1));
  if (vol == 0)
    return 1;

  file = hfs_open(vol, nargv[1]);
  if (file == 0)
    {
      hfs_perror("Error opening HFS file");
      return 1;
    }

  if (hfs_fstat(file, &dirent) < 0)
    {
      hfs_perror("Error getting HFS file information");
      return 1;
    }

  text = (fork == 0 && strcmp(dirent.type, "TEXT") == 0) ? 1 : 0;

  hfs_fork(file, fork);
  fflush(stdout);

  while ((bytes = hfs_read(file, buf, sizeof(buf))) > 0)
    {
      char *p;

      if (text)
	{
	  for (p = buf; p < buf + sizeof(buf); ++p)
	    {
	      if (*p == '\r')
		*p = '\n';
	    }
	}

      write(1, buf, bytes);
    }

  if (bytes < 0)
    {
      hfs_perror("Error reading HFS file");
      return 1;
    }

  if (hfs_close(file) < 0)
    {
      hfs_perror("Error closing HFS file");
      return 1;
    }

  if (hfs_umount(vol) < 0)
    {
      hfs_perror("Error closing HFS volume");
      return 1;
    }

  return 0;
}
