# include <unistd.h>
# include <string.h>
# include <netinet/in.h>
# include <fcntl.h>
# include <unistd.h>
# include <tcl.h>

# include "hfs.h"
# include "copyout.h"
# include "binhex.h"
# include "crc.h"

char *copyout_dest_name;

/*
 * NAME:	Hfs_CopyOutMacb()
 * DESCRIPTION:	copy a file from HFS to UNIX using MacBinary II
 */
int Hfs_CopyOutMacb(Tcl_Interp *interp, hfsfile *ifile, int ofile)
{
  char buf[512];
  long bytes;
  unsigned long total;
  hfsdirent ent;
  long lword;
  short word;
  unsigned short crc;

  if (hfs_fstat(ifile, &ent) < 0)
    {
      interp->result = "error getting file info";
      return TCL_ERROR;
    }

  interp->result = "error writing data";

  memset(buf, 0, 128);

  buf[1] = strlen(copyout_dest_name);
  strcpy(&buf[2], copyout_dest_name);

  memcpy(&buf[65], ent.type, 4);
  memcpy(&buf[69], ent.creator, 4);

  buf[73] = ent.fdflags >> 8;

  lword = htonl(ent.dsize);
  memcpy(&buf[83], &lword, sizeof(lword));

  lword = htonl(ent.rsize);
  memcpy(&buf[87], &lword, sizeof(lword));

  lword = htonl(ent.crdate + 2082844800);
  memcpy(&buf[91], &lword, sizeof(lword));

  lword = htonl(ent.mddate + 2082844800);
  memcpy(&buf[95], &lword, sizeof(lword));

  buf[101] = ent.fdflags & 0xff;

  buf[122] = buf[123] = 129;

  crc = Hfs_BlockCRC(buf, 124, 0x0000);

  word = htons(crc);
  memcpy(&buf[124], &word, sizeof(word));

  if (write(ofile, buf, 128) < 0)
    return TCL_ERROR;

  /* data fork */

  total = 0;
  while (1)
    {
      bytes = hfs_read(ifile, buf, sizeof(buf));
      if (bytes < 0)
	{
	  Tcl_SetResult(interp, hfs_error, TCL_STATIC);
	  return TCL_ERROR;
	}
      else if (bytes == 0)
	break;

      if (write(ofile, buf, bytes) < 0)
	return TCL_ERROR;

      total += bytes;
    }

  if (total != ent.dsize)
    {
      interp->result = "data fork length changed";
      return TCL_ERROR;
    }

  bytes = total % 128;
  if (bytes)
    {
      memset(buf, 0, 128);
      if (write(ofile, buf, 128 - bytes) < 0)
	return TCL_ERROR;
    }

  /* resource fork */

  hfs_fork(ifile, 1);

  total = 0;
  while (1)
    {
      bytes = hfs_read(ifile, buf, sizeof(buf));
      if (bytes < 0)
	{
	  Tcl_SetResult(interp, hfs_error, TCL_STATIC);
	  return TCL_ERROR;
	}
      else if (bytes == 0)
	break;

      if (write(ofile, buf, bytes) < 0)
	return TCL_ERROR;

      total += bytes;
    }

  if (total != ent.rsize)
    {
      interp->result = "resource fork length changed";
      return TCL_ERROR;
    }

  bytes = total % 128;
  if (bytes)
    {
      memset(buf, 0, 128);
      if (write(ofile, buf, 128 - bytes) < 0)
	return TCL_ERROR;
    }

  interp->result = "";
  return TCL_OK;
}

/*
 * NAME:	Hfs_CopyOutBinh()
 * DESCRIPTION:	copy a file from HFS to UNIX using BinHex
 */
int Hfs_CopyOutBinh(Tcl_Interp *interp, hfsfile *ifile, int ofile)
{
  hfsdirent ent;
  char byte;
  short word;
  long lword;
  char buf[512];
  long bytes;
  unsigned long total;

  if (hfs_fstat(ifile, &ent) < 0)
    {
      interp->result = "error getting file info";
      return TCL_ERROR;
    }

  interp->result = "error writing data";

  if (bh_start(ofile) < 0)
    return TCL_ERROR;

  byte = strlen(ent.name);
  if (bh_insert(&byte, 1) < 0 ||
      bh_insert(ent.name, byte + 1) < 0)
    return TCL_ERROR;

  if (bh_insert(ent.type, 4) < 0 ||
      bh_insert(ent.creator, 4) < 0)
    return TCL_ERROR;

  /* clear initted bit */
  word = htons(ent.fdflags & ~0x0001);
  if (bh_insert((char *) &word, 2) < 0)
    return TCL_ERROR;

  lword = htonl(ent.dsize);
  if (bh_insert((char *) &lword, 4) < 0)
    return TCL_ERROR;

  lword = htonl(ent.rsize);
  if (bh_insert((char *) &lword, 4) < 0)
    return TCL_ERROR;

  if (bh_insertcrc() < 0)
    return TCL_ERROR;

  /* data fork */

  total = 0;
  while (1)
    {
      bytes = hfs_read(ifile, buf, sizeof(buf));
      if (bytes < 0)
	{
	  Tcl_SetResult(interp, hfs_error, TCL_STATIC);
	  return TCL_ERROR;
	}
      else if (bytes == 0)
	break;

      if (bh_insert(buf, bytes) < 0)
	return TCL_ERROR;

      total += bytes;
    }

  if (total != ent.dsize)
    {
      interp->result = "data fork length changed";
      return TCL_ERROR;
    }

  if (bh_insertcrc() < 0)
    return TCL_ERROR;

  /* resource fork */

  hfs_fork(ifile, 1);

  total = 0;
  while (1)
    {
      bytes = hfs_read(ifile, buf, sizeof(buf));
      if (bytes < 0)
	{
	  Tcl_SetResult(interp, hfs_error, TCL_STATIC);
	  return TCL_ERROR;
	}
      else if (bytes == 0)
	break;

      if (bh_insert(buf, bytes) < 0)
	return TCL_ERROR;

      total += bytes;
    }

  if (total != ent.rsize)
    {
      interp->result = "resource fork length changed";
      return TCL_ERROR;
    }

  if (bh_insertcrc() < 0)
    return TCL_ERROR;

  if (bh_end() < 0)
    return TCL_ERROR;

  interp->result = "";
  return TCL_OK;
}

/*
 * NAME:	Hfs_CopyOutText()
 * DESCRIPTION:	copy a file from HFS to UNIX using text translation
 */
int Hfs_CopyOutText(Tcl_Interp *interp, hfsfile *ifile, int ofile)
{
  char buf[512];
  long bytes;

  while (1)
    {
      char *ptr;

      bytes = hfs_read(ifile, buf, sizeof(buf));
      if (bytes < 0)
	{
	  Tcl_SetResult(interp, hfs_error, TCL_STATIC);
	  return TCL_ERROR;
	}
      else if (bytes == 0)
	break;

      for (ptr = buf; ptr < buf + bytes; ++ptr)
	{
	  if (*ptr == '\r')
	    *ptr = '\n';
	}

      if (write(ofile, buf, bytes) < 0)
	{
	  interp->result = "error writing data";
	  return TCL_ERROR;
	}
    }

  return TCL_OK;
}

/*
 * NAME:	Hfs_CopyOutRaw()
 * DESCRIPTION:	copy a file from HFS to UNIX using no translation
 */
int Hfs_CopyOutRaw(Tcl_Interp *interp, hfsfile *ifile, int ofile)
{
  char buf[512];
  long bytes;

  while (1)
    {
      bytes = hfs_read(ifile, buf, sizeof(buf));
      if (bytes < 0)
	{
	  Tcl_SetResult(interp, hfs_error, TCL_STATIC);
	  return TCL_ERROR;
	}
      else if (bytes == 0)
	break;

      if (write(ofile, buf, bytes) < 0)
	{
	  interp->result = "error writing data";
	  return TCL_ERROR;
	}
    }

  return TCL_OK;
}
