# include <stdio.h>
# include <string.h>

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "hvol.h"

int hvol_main(int argc, char *argv[])
{
  int vnum;
  mountent *ent;

  if (argc > 2)
    {
      fprintf(stderr, "Usage: %s [volume-name-or-path]\n", argv[0]);
      return 1;
    }

  if (argc == 1)
    {
      ent = hcwd_getvol(-1);
      if (ent)
	printf("Current volume is \"%s\" on %s\n", ent->vname, ent->path);

      printf("Known volumes:\n");

      for (vnum = 0; ; ++vnum)
	{
	  ent = hcwd_getvol(vnum);
	  if (ent == 0)
	    return 0;

	  if (ent->partno <= 1)
	    printf("  %-20s     %s\n", ent->path, ent->vname);
	  else
	    printf("  %-20s %2d  %s\n", ent->path, ent->partno, ent->vname);
	}
    }

  for (vnum = 0; ; ++vnum)
    {
      ent = hcwd_getvol(vnum);
      if (ent == 0)
	{
	  fprintf(stderr, "%s: Volume \"%s\" not currently mounted\n",
		  argv[0], argv[1]);
	  return 1;
	}

      if (strcmp(argv[1], ent->path) == 0 ||
	  strcasecmp(argv[1], ent->vname) == 0)
	{
	  hfsvol *vol;

	  hcwd_setvol(vnum);
	  vol = hfs_remount(argv[0], ent);
	  if (vol == 0)
	    return 1;

	  if (hfs_umount(vol) < 0)
	    {
	      hfs_perror("Error closing HFS volume");
	      return 1;
	    }

	  return 0;
	}
    }
}
