# include <stdio.h>
# include <stdlib.h>
# include <string.h>

# ifdef DMALLOC
# include <dmalloc.h>
# endif

# include "hfs.h"
# include "hcwd.h"
# include "hfsutil.h"
# include "hcd.h"

/*
 * NAME:	hfs_getcwd()
 * DESCRIPTION:	return full path to current directory
 */
static
char *hfs_getcwd(hfsvol *vol)
{
  char *path, name[33];
  long cwd;
  int pathlen;

  path    = malloc(1);
  path[0] = 0;
  pathlen = 0;
  cwd     = hfs_cwdid(vol);

  while (cwd != HFS_CNID_ROOTPAR)
    {
      char *new;
      int namelen, i;

      if (hfs_dirinfo(vol, &cwd, name) < 0)
	return 0;

      if (pathlen)
	strcat(name, ":");

      namelen = strlen(name);

      new = realloc(path, namelen + pathlen + 1);
      if (new == 0)
	{
	  free(path);
	  hfs_error = "out of memory";
	  return 0;
	}

      if (pathlen == 0)
	new[0] = 0;

      path = new;

      /* push string down to make room for path prefix (memmove()-ish) */

      i = pathlen + 1;
      for (new = path + namelen + pathlen; i--; new--)
	*new = *(new - namelen);

      memcpy(path, name, namelen);

      pathlen += namelen;
    }

  return path;
}

int hcd_main(int argc, char *argv[])
{
  mountent *ent;
  hfsvol *vol;
  char *path, root[29];

  if (argc > 2)
    {
      fprintf(stderr, "Usage: %s [hfs-path]\n", argv[0]);
      return 1;
    }

  vol = hfs_remount(argv[0], ent = hcwd_getvol(-1));
  if (vol == 0)
    return 1;

  if (argc == 2)
    path = argv[1];
  else
    {
      strcpy(root, hfs_vname(vol));
      strcat(root, ":");
      path = root;
    }

  if (hfs_chdir(vol, path) < 0)
    {
      hfs_perror("Can't change HFS directory");
      return 1;
    }

  path = hfs_getcwd(vol);
  if (path == 0)
    {
      hfs_perror("Can't get new HFS directory path");
      return 1;
    }

  if (hfs_umount(vol) < 0)
    {
      hfs_perror("Error closing HFS volume");
      return 1;
    }

  if (hcwd_setcwd(ent, path) < 0)
    {
      perror("Can't set new HFS directory");
      return 1;
    }

  free(path);

  return 0;
}
